//
//  VSLogging.h
//  GStreamer iOS Tutorials
//
//  Created by Patrick Rogers on 11/21/13.
//
//

#ifndef GStreamer_iOS_Tutorials_logging_h
#define GStreamer_iOS_Tutorials_logging_h

// adapted from: http://stackoverflow.com/questions/1667994/best-practices-for-error-logging-and-or-reporting-for-iphone

#ifndef LOG_LEVEL
#if TARGET_IPHONE_SIMULATOR != 0
#define LOG_LEVEL 3
#else
#define LOG_LEVEL 3
#endif
#endif

/*****************************************************************************/
/* Entry/exit trace macros                                                   */
/*****************************************************************************/
#if LOG_LEVEL >= 3
#define TRC_ENTRY    NSLog(@"ENTRY: %s:%d:", __PRETTY_FUNCTION__,__LINE__);
#define TRC_EXIT     NSLog(@"EXIT:  %s:%d:", __PRETTY_FUNCTION__,__LINE__);
#else
#define TRC_ENTRY
#define TRC_EXIT
#endif

/*****************************************************************************/
/* Debug trace macros                                                        */
/*****************************************************************************/
#if (LOG_LEVEL >= 0)
#define LOG_ERR(A, ...) NSLog(@"ERROR: %s:%d:%@", __PRETTY_FUNCTION__,__LINE__,[NSString stringWithFormat:A, ## __VA_ARGS__]);
#else
#define LOG_ERR(A, ...)
#endif

#if (LOG_LEVEL >= 1)
#define LOG_INFO(A, ...) NSLog(@"INFO: %s:%d:%@", __PRETTY_FUNCTION__,__LINE__,[NSString stringWithFormat:A, ## __VA_ARGS__]);
#else
#define LOG_INFO(A, ...)
#endif

#if (LOG_LEVEL >= 2)
#define LOG_DEBUG(A, ...) NSLog(@"DEBUG:%s:%d:%@", __PRETTY_FUNCTION__,__LINE__,[NSString stringWithFormat:A, ## __VA_ARGS__]);
#else
#define LOG_DEBUG(A, ...)
#endif

#if (LOG_LEVEL >= 3)
#define LOG_TRACE(A, ...) NSLog(@"TRACE: %s:%d:%@", __PRETTY_FUNCTION__,__LINE__,[NSString stringWithFormat:A, ## __VA_ARGS__]);
#else
#define LOG_TRACE(A, ...)
#endif

#endif
